<!doctype html>
<html lang="en">

<head>
  <title>San Diego Elder Care</title>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

  <link
    href="https://fonts.googleapis.com/css2?family=Open+Sans:wght@400;700&family=Playfair+Display:wght@400;700&display=swap"
    rel="stylesheet">

  <!-- Bootstrap CSS -->
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.0.0/dist/css/bootstrap.min.css"
    integrity="sha384-Gn5384xqQ1aoWXA+058RXPxPg6fy4IWvTNh0E263XmFcJlSAwiGgFAW/dAiS6JXm" crossorigin="anonymous">

  <!-- font awesome -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.6.0/css/all.min.css"
    integrity="sha512-Kc323vGBEqzTmouAECnVceyQqyqdsSiqLQISBL29aUW4U/M7pSPA/gEUZQqv1cwx4OnYxTxve5UMg5GT6L4JJg=="
    crossorigin="anonymous" referrerpolicy="no-referrer" />

  <!-- for testimonial owl carousel -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/owl-carousel/1.3.3/owl.carousel.min.css">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/owl-carousel/1.3.3/owl.theme.min.css">

  <link rel="stylesheet" href="css/style.css">

  <style>
    .value-math {
      opacity: 0;
      height: 0;
    }
  </style>

  <!-- captcha js -->
  <script type='text/javascript'>
    <?php
    $n1 = rand(1, 9); //Generate First number between 1 and 6  
    $n2 = rand(1, 9); //Generate Second number between 5 and 9  
    $answer = $n1 + $n2;
    $math = $n1 . " + " . $n2 . " : ";
    $_SESSION['vercode'] = $answer;


    /*dummy field value*/
    $d_n1 = rand(1, 9); //Generate First number between 1 and 6  
    $d_n2 = rand(1, 9); //Generate Second number between 5 and 9  
    $d_answer = $d_n1 + $d_n2;
    $d_math = $d_n1 . " + " . $d_n2 . " : ";
    /* $_SESSION['vercode'] = $d_answer;*/

    ?>

    function ValidmathCaptcha() {

      var captcha = document.getElementById('captcha').value;
      var value = '<?php echo $answer; ?>';
      if (captcha !== value) {
        alert("Please Enter correct captcha Value");
        event.preventDefault();
        document.getElementById('captcha').value = ""
      }
    }
  </script>

</head>

<body>

  <div>
    <header class="site-navbar light js-sticky-header site-navbar-target" role="banner">

      <nav class="navbar navbar-expand-lg fixed-top navbar-light bg-white px-2 px-md-3" id="navbar">
        <a class="" href="index.php">
          <img src="images/logo.png" alt="elder care" width="225px">
        </a>
        <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarCollapse"
          aria-controls="navbarCollapse" aria-expanded="false" aria-label="Toggle navigation">
          <span class="navbar-toggler-icon"><i class="fas fa-bars navbar-brand nav-link"></i></span>
        </button>


        <div class="collapse navbar-collapse" id="navbarCollapse">
          <ul class="navbar-nav ml-auto">
            <li class="nav-item">
              <a class="nav-link px-2 px-xl-3 text-dark font-weight-bold" href="index.php">Home</a>
            </li>
            <li class="nav-item">
              <a class="nav-link px-2 px-xl-3 text-dark font-weight-bold" href="about.html">About Us</a>
            </li>
            <li class="nav-item">
              <a class="nav-link px-2 px-xl-3 text-dark font-weight-bold" href="#service">Services</a>
            </li>
            <li class="nav-item">
              <a class="nav-link px-2 px-xl-3 text-dark font-weight-bold" href="gallery.html#gallery">Gallery</a>
            </li>
            <li class="nav-item">
              <a class="nav-link px-2 px-xl-3 text-dark font-weight-bold" href="#testimonial">Testimonials</a>
            </li>
            <li class="nav-item">
              <a class="nav-link px-2 px-xl-3 text-dark font-weight-bold" href="stories.html#story">Success Stories</a>
            </li>
            <li class="nav-item">
              <a class="nav-link px-2 px-xl-3 text-dark font-weight-bold" href="#location">Locations</a>
            </li>
            <li class="nav-item">
              <a class="nav-link px-2 px-xl-3 text-dark font-weight-bold" href="#contact">Contact Us</a>
            </li>
            <!-- <li class="social"><a href="#contact-section" class="nav-link"><span class="icon-facebook"></span></a></li>
            <li class="social"><a href="#contact-section" class="nav-link"><span class="icon-twitter"></span></a></li>
            <li class="social"><a href="#contact-section" class="nav-link"><span class="icon-linkedin"></span></a></li> -->
          </ul>

        </div>
      </nav>

    </header>


    <!-- MAIN -->
    <div class="slide-item overlay"
      style="background-image: linear-gradient(rgba(9, 22, 29, 0.397),rgba(9, 22, 29, 0.397)), url('images/slider-1.jpg'); margin-top: 78px;">
      <div class="container">
        <div class="row">
          <div class="col-lg-6 align-self-center">
            <h1 class="heading mb-3">Expert Care for the Elderly</h1>
            <p class="lead text-white mb-5">Empowering seniors to live life to the fullest with resources, community
              support, and engaging activities tailored just for them.</p>
            <p><a href="#contact" class="btn btn-primary">Get In Touch</a></p>
          </div>
        </div>
      </div>
    </div>


    <!-- <div class="feature-v1">
      <div class="d-lg-flex align-items-center w-100">
        <div class="d-flex pagination-item  h-100">
          <span class="icon-wrap">
            <img src="images/svg1.svg" alt="Image" class="img-fluid">
          </span>
          <div>
            <span class="subheading">Our Services</span>
            <h3 class="heading">Independent Living For Senior Couples</h3>
            <a href="about.html" class="small">Learn More</a>
          </div>
        </div>
        <div class="d-flex pagination-item h-100">
          <span class="icon-wrap">
            <img src="images/svg2.svg" alt="Image" class="img-fluid">
          </span>
          <div>
            <span class="subheading">Our Services</span>
            <h3 class="heading">We Are Helping the Senior Elderly People</h3>
            <a href="about.html" class="small">Learn More</a>
          </div>
        </div>
        <div class="d-flex pagination-item h-100">
          <span class="icon-wrap">
            <img src="images/svg3.svg" alt="Image" class="img-fluid">
          </span>
          <div>
            <span class="subheading">Our Services</span>
            <h3 class="heading">Senior Home Patient Care Services</h3>
            <a href="about.html" class="small">Learn More</a>
          </div>
        </div>
      </div>
    </div> -->

    <!-- about us -->
    <div class="site-section aboutus" id="about">
      <div class="container">
        <div class="row">
          <div class="col-md-12 col-lg-6 mb-5 mb-md-0">
            <img src="images/fun-img_4-about.jpg" alt="Image" class="img-fluid">
          </div>
          <div class="col-md-12 col-lg-5 ml-lg-5">
            <div class="section-heading">
              <h2 class="heading mb-3 text-blue">San Diego Elder Care</h2>

              <p class="text-dark">San Diego Elder Care is a small family business operated by my husband, Gary and myself, Nikky. Gary has 20+ years of experience in healthcare industry; I am a CFA, CPA and MBA and have an extensive background in finance.</p>
              <p class="mb-4 text-dark">I volunteered in elder care industry for over 4 years before I and Gary decided that it’s time to start something of our own. We both are born and raised in India and caring for elderly comes naturally to us because we have seen our parents take care of our grandparents all our lives. We strongly believe that compassion cannot be taught, but is innate. We feel like since we started this business, we both have found our life’s purpose.
              </p>
              <!-- <p class="text-blue"><strong class="h3">&ldquo;We care for elderly people&rdquo;</strong></p> -->
              <p><a href="about.html" class="btn btn-white border-primary text-dark">Learn More</a></p>
            </div>
          </div>
        </div>
      </div>
    </div>

    <!-- <div class="section3 count-numbers py-4">
      <div class="container">
        <div class="row">
          <div class="col-6 col-sm-6 col-md-6 col-lg-3 mb-4 mb-lg-0">
            <div class="counter-wrap text-center">
              <img src="images/room-available.png" alt="Image" width="140px">
              <p>Rooms Available</p>
            </div>
          </div>
          <div class="col-6 col-sm-6 col-md-6 col-lg-3 mb-4 mb-lg-0">
            <div class="counter-wrap text-center">
              <img src="images/staff.png" alt="Image" width="115px">
              <p>Nurse Staff</p>
            </div>
          </div>
          <div class="col-6 col-sm-6 col-md-6 col-lg-3 mb-4 mb-lg-0">
            <div class="counter-wrap text-center">
              <img src="images/senior-living.png" alt="Image" width="140px">
              <p>Senior Living</p>
            </div>
          </div>
          <div class="col-6 col-sm-6 col-md-6 col-lg-3 mb-4 mb-lg-0">
            <div class="counter-wrap text-center">
              <img src="images/happy-people.png" alt="Image" width="140px">
              <p>Happy People</p>
            </div>
          </div>
        </div>
      </div>
    </div> -->

    <!-- our services -->
    <div class="site-section" id="service">
      <div class="container-fluid">
        <h2 class="text-center text-blue">Our Services</h2>
        <p class="text-center service-para my-4">All our homes at San Diego Elder Care are designed to care for both
          ambulatory and non-ambulatory clients who do not wish to or are unable to live alone but who need:</p>
        <div class="row">

          <div class="col-12 col-md-6 mb-4 mb-lg-0 col-lg-3">
            <div class="service">
              <img src="images/elderly-fun/fun-img_3.jpg" alt="Image" class="img-fluid">
              <div class="service-inner">
                <h3>A place to live in a home like environment</h3>
              </div>
            </div>
          </div>
          <div class="col-12 col-md-6 mb-4 mb-lg-0 col-lg-3">
            <div class="service">
              <img src="images/elderly-fun/fun-img_1.jpg" alt="Image" class="img-fluid">
              <div class="service-inner">
                <h3>Live in a warm setting with plenty of enjoyable activities.</h3>
              </div>
            </div>
          </div>
          <div class="col-12 col-md-6 mb-4 mb-lg-0 col-lg-3">
            <div class="service">
              <img src="images/elderly-fun/fun-img_4.jpg" alt="Image" class="img-fluid">
              <div class="service-inner">
                <h3>Join us for a cozy place where comfort and care come together.</h3>
              </div>
            </div>
          </div>
          <div class="col-12 col-md-6 mb-4 mb-lg-0 col-lg-3">
            <div class="service">
              <img src="images/elderly-activity/activity-img_1.jpg" alt="Image" class="img-fluid">
              <div class="service-inner">
                <h3>Experience comfort and engaging activities in our community.</h3>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>

    <div class="site-section">
      <div class="container">
        <div class="row align-items-center">
          <div class="col-lg-8">
            <div class="section-heading">
              <h2 class="heading mb-3 text-blue">Let us take your worries away!</h2>
              <p class="mb-5">At our senior care facilities, we prioritize the well-being of your loved ones with
                personalized care and a supportive community. Trust us to provide peace of mind and exceptional support
                for your family.</p>

              <div class="row">
                <!-- <div class="col-lg-6">
                  <img src="images/img_3.jpg" alt="Image" class="img-fluid">
                </div> -->
                <div class="col-lg-6">
                  <ul class="list-unstyled ul-check primary">
                    <li class="d-flex align-items-baseline"><i class="fas fa-check text-blue mr-3"></i>Delicious and
                      nutritious home-cooked meals (3 meals plus snacks)</li>
                    <li class="d-flex align-items-baseline"><i class="fas fa-check text-blue mr-3"></i>Emergency
                      medical resources like on call doctors, nurses, PT, OT </li>
                    <li class="d-flex align-items-baseline"><i class="fas fa-check text-blue mr-3"></i>Haircuts,
                      manicure, pedicure, when requested</li>
                    <li><i class="fas fa-check text-blue mr-3"></i>Housekeeping and linen service</li>
                    <li><i class="fas fa-check text-blue mr-3"></i>Incontinence care</li>
                    <li><i class="fas fa-check text-blue mr-3"></i>To be part of a family atmosphere</li>
                    <li class="d-flex align-items-baseline"><i class="fas fa-check text-blue mr-3"></i>Two on-site
                      caregivers at all times to provide 24-hour supervision</li>
                  </ul>
                </div>
                <div class="col-lg-6">
                  <ul class="list-unstyled ul-check primary">
                    <li><i class="fas fa-check text-blue mr-3"></i>Dementia / Memory Care</li>
                    <li class="d-flex align-items-baseline"><i class="fas fa-check text-blue mr-3"></i>Full
                      assistance with dressing, bathing, shaving, personal hygiene and grooming</li>
                    <li><i class="fas fa-check text-blue mr-3"></i>Hospice services</li>
                    <li><i class="fas fa-check text-blue mr-3"></i>Hoyer Lift Assistance</li>
                    <li><i class="fas fa-check text-blue mr-3"></i>Laundry services</li>
                    <li class="d-flex align-items-baseline"><i class="fas fa-check text-blue mr-3"></i>Medical
                      transportation, when required</li>
                    <li><i class="fas fa-check text-blue mr-3"></i>2 person assistance, if needed</li>
                    <li><i class="fas fa-check text-blue mr-3"></i>Respite care </li>
                    <li><i class="fas fa-check text-blue mr-3"></i>Special diet, when indicated</li>
                    <li><i class="fas fa-check text-blue mr-3"></i>Supervision of medications</li>
                  </ul>
                </div>
              </div>
            </div>
          </div>
          <div class="col-lg-4">

            <div class="d-block custom-media algin-items-stretch  mt-4">
              <!-- <div class="text text-center">
                <h3>You can live here with love</h3>
              </div> -->
              <div class="img-bg" style="background-image: url('images/img_2.jpg')"></div>
            </div>
          </div>
        </div>
      </div>
    </div>

    <!-- gallery -->
    <div class="desktop_7" unique-script-id="w-w-dm-id">
      <div class="responsive-container-block bigContainer">
        <div class="responsive-container-block Container">
          <h2 class="text-center text-blue mb-5">
            Gallery
          </h2>
          <!-- <div class="responsive-container-block optionsContainer">
            <p class="text-blk list all active" data-filter="all">
              All
            </p>
            <p class="text-blk list" data-filter="activity">
              Activity
            </p>
            <p class="text-blk list" data-filter="food">
              Food
            </p>
            <p class="text-blk list" data-filter="fun">
              Fun
            </p>
            <p class="text-blk list" data-filter="celebration">
              Celebration
            </p>
          </div> -->
          <div class="responsive-container-block imageContainer">
            <div class="project">
              <div class="overlay2">
                <div class="overlay-inner">
                  <button class="close">
                    X
                  </button>
                  <div class="hdImgs">
                    <img alt="" class="galleryImg" src="images/elderly-activity/activity-img_1.jpg">
                  </div>
                </div>
              </div>
              <img class="squareImg activity" src="images/elderly-activity/activity-img_1.jpg">
              <div class="btn-box">
                <button class="btn">
                  View
                </button>
              </div>
            </div>
            <div class="project">
              <img class="squareImg food" src="images/elderly-food/food-img6.jpeg">
              <div class="overlay2">
                <div class="overlay-inner">
                  <button class="close">
                    X
                  </button>
                  <div class="hdImgs">
                    <img class=" food galleryImg" src="images/elderly-food/food-img6.jpeg">
                  </div>
                </div>
              </div>
              <div class="btn-box">
                <button class="btn">
                  View
                </button>
              </div>
            </div>
            <div class="project">
              <img class="squareImg fun" src="images/elderly-fun/fun-img_1.jpg">
              <div class="overlay2">
                <div class="overlay-inner">
                  <button class="close">
                    X
                  </button>
                  <div class="hdImgs">
                    <img alt="" class="galleryImg" src="images/elderly-fun/fun-img_1.jpg">
                  </div>
                </div>
              </div>
              <div class="btn-box">
                <button class="btn">
                  View
                </button>
              </div>
            </div>
            <div class="project">
              <video class="squareImg activity" width="400" controls>
                <source src="images/video-g-1.mp4" type="video/mp4">
              </video>
              <div class="overlay2">
                <div class="overlay-inner">
                  <button class="close">
                    X
                  </button>
                  <div class="hdImgs">
                    <video width="100%" height="300" controls>
                      <source src="images/video-g-1.mp4" type="video/mp4">
                    </video>
                  </div>
                </div>
              </div>
              <div class="btn-box">
                <button class="btn">
                  View
                </button>
              </div>
            </div>
            <div class="project">
              <img class="squareImg celebration" src="images/elderly-celebration/celebration-img_1.jpg">
              <div class="overlay2">
                <div class="overlay-inner">
                  <button class="close">
                    X
                  </button>
                  <div class="hdImgs">
                    <img alt="" class="galleryImg" src="images/elderly-celebration/celebration-img_1.jpg">
                  </div>
                </div>
              </div>
              <div class="btn-box">
                <button class="btn">
                  View
                </button>
              </div>
            </div>

            <div class="project">
              <img class="squareImg activity" src="images/elderly-activity/activity-img_2.jpg">
              <div class="overlay2">
                <div class="overlay-inner">
                  <button class="close">
                    X
                  </button>
                  <div class="hdImgs">
                    <img alt="" class="galleryImg" src="images/elderly-activity/activity-img_2.jpg">
                  </div>
                </div>
              </div>
              <div class="btn-box">
                <button class="btn">
                  View
                </button>
              </div>
            </div>
            <div class="project">
              <img class="squareImg celebration" src="images/elderly-celebration/celebration-img_2.jpg">
              <div class="overlay2">
                <div class="overlay-inner">
                  <button class="close">
                    X
                  </button>
                  <div class="hdImgs">
                    <img alt="" class="galleryImg" src="images/elderly-celebration/celebration-img_2.jpg">
                  </div>
                </div>
              </div>
              <div class="btn-box">
                <button class="btn">
                  View
                </button>
              </div>
            </div>
            <div class="project">
              <video class="squareImg activity" width="400" controls>
                <source src="images/video-g-3.mp4" type="video/mp4">
              </video>
              <div class="overlay2">
                <div class="overlay-inner">
                  <button class="close">
                    X
                  </button>
                  <div class="hdImgs">
                    <video width="100%" height="300" controls>
                      <source src="images/video-g-3.mp4" type="video/mp4">
                    </video>
                  </div>
                </div>
              </div>
              <div class="btn-box">
                <button class="btn">
                  View
                </button>
              </div>
            </div>
            <div class="project">
              <img class="squareImg food" src="images/elderly-food/food-img2.jpeg">
              <div class="overlay2">
                <div class="overlay-inner">
                  <button class="close">
                    X
                  </button>
                  <div class="hdImgs">
                    <img alt="" class="galleryImg" src="images/elderly-food/food-img2.jpeg">
                  </div>
                </div>
              </div>
              <div class="btn-box">
                <button class="btn">
                  View
                </button>
              </div>
            </div>
            <div class="project">
              <video class="squareImg activity" width="400" controls>
                <source src="images/video-g-4.mp4" type="video/mp4">
              </video>
              <div class="overlay2">
                <div class="overlay-inner">
                  <button class="close">
                    X
                  </button>
                  <div class="hdImgs">
                    <video width="100%" height="300" controls>
                      <source src="images/video-g-4.mp4" type="video/mp4">
                    </video>
                  </div>
                </div>
              </div>
              <div class="btn-box">
                <button class="btn">
                  View
                </button>
              </div>
            </div>
            <!-- <div class="project">
              <img class="squareImg fun" src="images/fun-img_2.jpg">
              <div class="overlay2">
                <div class="overlay-inner">
                  <button class="close">
                    X
                  </button>
                  <div class="hdImgs">
                    <img alt="" class="galleryImg" src="images/fun-img_2.jpg">
                  </div>
                </div>
              </div>
              <div class="btn-box">
                <button class="btn">
                  View
                </button>
              </div>
            </div> -->
            <div class="project">
              <img class="squareImg food" src="images/elderly-food/food-img3.jpeg">
              <div class="overlay2">
                <div class="overlay-inner">
                  <button class="close">
                    X
                  </button>
                  <div class="hdImgs">
                    <img alt="" class="galleryImg" src="images/elderly-food/food-img3.jpeg">
                  </div>
                </div>
              </div>
              <div class="btn-box">
                <button class="btn">
                  View
                </button>
              </div>
            </div>
            <!-- <div class="project">
              <img class="squareImg activity" src="images/activity-img_3.jpg">
              <div class="overlay2">
                <div class="overlay-inner">
                  <button class="close">
                    X
                  </button>
                  <div class="hdImgs">
                    <img alt="" class="galleryImg" src="images/activity-img_3.jpg">
                  </div>
                </div>
              </div>
              <div class="btn-box">
                <button class="btn">
                  View
                </button>
              </div>
            </div> -->
            <div class="project">
              <img class="squareImg celebration" src="images/elderly-celebration/celebration-img_3.jpg">
              <div class="overlay2">
                <div class="overlay-inner">
                  <button class="close">
                    X
                  </button>
                  <div class="hdImgs">
                    <img alt="" class="galleryImg" src="images/elderly-celebration/celebration-img_3.jpg">
                  </div>
                </div>
              </div>
              <div class="btn-box">
                <button class="btn">
                  View
                </button>
              </div>
            </div>
            <div class="project">
              <img class="squareImg fun" src="images/elderly-fun/fun-img_3.jpg">
              <div class="overlay2">
                <div class="overlay-inner">
                  <button class="close">
                    X
                  </button>
                  <div class="hdImgs">
                    <img alt="" class="galleryImg" src="images/elderly-fun/fun-img_3.jpg">
                  </div>
                </div>
              </div>
              <div class="btn-box">
                <button class="btn">
                  View
                </button>
              </div>
            </div>
            <div class="project">
              <img class="squareImg activity" src="images/elderly-activity/activity-img_4.jpg">
              <div class="overlay2">
                <div class="overlay-inner">
                  <button class="close">
                    X
                  </button>
                  <div class="hdImgs">
                    <img alt="" class="galleryImg" src="images/elderly-activity/activity-img_4.jpg">
                  </div>
                </div>
              </div>
              <div class="btn-box">
                <button class="btn">
                  View
                </button>
              </div>
            </div>
            <div class="project">
              <img class="squareImg celebration" src="images/elderly-celebration/celebration-img_4.jpg">
              <div class="overlay2">
                <div class="overlay-inner">
                  <button class="close">
                    X
                  </button>
                  <div class="hdImgs">
                    <img alt="" class="galleryImg" src="images/elderly-celebration/celebration-img_4.jpg">
                  </div>
                </div>
              </div>
              <div class="btn-box">
                <button class="btn">
                  View
                </button>
              </div>
            </div>
            <div class="project">
              <img class="squareImg food" src="images/elderly-food/food-img4.jpeg">
              <div class="overlay2">
                <div class="overlay-inner">
                  <button class="close">
                    X
                  </button>
                  <div class="hdImgs">
                    <img alt="" class="galleryImg" src="images/elderly-food/food-img4.jpeg">
                  </div>
                </div>
              </div>
              <div class="btn-box">
                <button class="btn">
                  View
                </button>
              </div>
            </div>





            <a href="gallery.html#gallery"><button
                class="moreless-button d-flex mx-auto btn bg-blue text-white mt-2">View more</button></a>
          </div>

        </div>
      </div>
    </div>

    <!-- testimonial -->
    <div class="container mt-4" id="testimonial">
      <h2 class="text-center text-blue pt-3">Reviews/Testimonials</h2>
      <div class="row mt-5">
        <div class="col-md-offset-2 col-md-12">
          <div id="testimonial-slider" class="owl-carousel">
            <div class="testimonial">
              <div class="testimonial-content">
                <p class="description">
                  My experience with EEC is excellent. All participants are always alert and responsive to my husband
                  and my needs. Caregivers are experienced, respectful and happy. My husband is relaxed and peaceful. I
                  know if I have a question it will be answered promptly and correctly. I trust all is going very well
                  !!! <span> <b> - Maria Shay</b></span>
                </p>
              </div>
            </div>
            <div class="testimonial">
              <div class="testimonial-content">
                <p class="description">
                  They are wonderful, we were so fortunate to find this unique comfortable place for my husband. Staff
                  was great, caring and compassionate. They took quick action as health issues changed. I thank them so
                  much for making my husband's stay there a positive and comfortable experience. <span><b>- Beverly
                      Nelligan</b> </span>
                </p>
              </div>
            </div>
            <div class="testimonial">
              <div class="testimonial-content">
                <p class="description">
                  In a time of sadness and turmoil La Mesa Elder Care came to the rescue. The house is modern, clean and
                  welcoming. The caregivers are competent, caring and attentive. The communication between Jenny , the
                  administrator, and family keeps us in the loop on everything and allows us to be comfortable when we
                  are not there. <span><b>- Judi Wilensky</b></span>
                </p>
              </div>
            </div>
            <div class="testimonial">
              <div class="testimonial-content">
                <p class="description">
                  Good afternoon,
                  I wanted to have a chance to Thank you Nikky and all the care staff at Safe Harbor Eldercare for the amazing care that you all provided for mom over her stay at Safe Harbor over the last couple of years and 8 months.
                  You're all angels and became an extension of our family. Mom loved you all as we did also. <span class="moretext">She was so happy there and we always felt that she was in very good hands. I will be back in San Diego in the following weeks. Mom's service is also scheduled in the coming weeks. It would be great if any of you can make it. God bless you all and I am forever grateful for you all! Love you all! 💖🙏🏼💖</span>
                  <span><b>- Sonia Casillas</b></span>
                </p>
                <button class="moreless-button d-flex mx-auto btn bg-blue text-white mt-2">Read more</button>
              </div>
            </div>
            <div class="testimonial">
              <div class="testimonial-content">
                <p class="description">
                  My mom was in a larger facility, but I am so grateful for the transition to this facility. I admire
                  the director’s passion for what she does. The facility feels more like a home, which is such a
                  refreshing approach on elder and memory care. Just the environment my mom needs.
                  The director does a wonderful job communicating. The staff at the location are always attentive. I
                  feel peace of mind knowing that my mother is getting the best care she possibly can.
                  <span><b> - Jasmine Reyes</b></span>
                </p>
              </div>
            </div>
            <div class="testimonial">
              <div class="testimonial-content">
                <p class="description">
                  Our mother was cared for at Poway Elder once she needed a higher level of care than she was able to
                  get at her independent living place. We interviewed several homes and Poway Elder care seemed a great
                  fit. I was very impressed by the wonderful, kind care givers, home cooked meals, rigorous medical
                  management, etc.
                  <span class="moretext">They even referred us to an excellent traveling physician, who would see her at
                    the facility. They also brought in a podiatrist and hairstylist so it truly is a one stop shop. We
                    had many family’s gatherings on their lovely back patio space and we were able to bring in food and
                    celebrate special occasions there. I was probably there every other day myself. They really
                    encourage family visits. Though mom is gone now. We were blessed to have Poway Elder Care’s
                    exceptional care and I would highly recommend them for your loved one. <span><b>- Rich
                        Cosand</b></span> </span>

                </p>
                <button class="moreless-button d-flex mx-auto btn bg-blue text-white mt-2">Read more</button>
              </div>
            </div>
            <div class="testimonial">
              <div class="testimonial-content">
                <p class="description">
                  Poway Elder Care is such a hidden gem! Nikki and her husband are such caring people as well as
                  caregivers! I could no longer care for my husband alone. The caregivers are so caring and treat my
                  husband with much love and support! It was hard for me to leave but as time goes Iam so at peace with
                  everyone here! <span class="moretext">The home is well kept and I also feel at home when I come to
                    visit Thank you so much for everything you do! <span><b>- Linda Seals </b></span>
                  </span>

                </p>
                <button class="moreless-button d-flex mx-auto btn bg-blue text-white mt-2">Read more</button>
              </div>
            </div>
            <div class="testimonial">
              <div class="testimonial-content">
                <p class="description">
                  Wow, what an amazing place! Great house with great backyard, especially place to walk near fruit
                  trees, great surroundings, and most importantly amazing caregivers! The owner/manager is absolutely
                  amazing, very special, gives so much personal attention, care and love. My wife loves the food there
                  and few small things she needs every morning, and she always gets them!
                  <span class="moretext">When we saw the place, we felt this is a miracle for us! The perfect place for
                    my wife! She was at beautiful, big Nursing Home, it was like 5-star hotel! But she loves this “home”
                    atmosphere, care and love so much more, that when I showed her the place, she asked me, “Can I
                    please stay here?” It's a blessing to us! Thank you so much for providing “home’ for her!
                    <span><b>- Satish Satpute</b></span></span>
                </p>
                <button class="moreless-button d-flex mx-auto btn bg-blue text-white mt-2">Read more</button>
              </div>
            </div>
            <div class="testimonial">
              <div class="testimonial-content">
                <p class="description">
                  First of all the house is lovely with a beautiful view. But most of all, the staff is wonderful! They
                  were so caring and loving with our mom, we couldn’t have asked for a better place for her to
                  live.♥️♥️♥️
                  <span><b>- Kathy Oakley</b></span>
                </p>
              </div>
            </div>
            <div class="testimonial">
              <div class="testimonial-content">
                <p class="description">
                  I feel very fortunate that I discovered Safe Harbor Elder Care. It was the perfect home for my mother.
                  The staff works very hard to prepare good meals, keep the house spotless and the bedrooms clean and
                  tidy. They also take care of the laundry, provide the medication, and tend to any special needs of the
                  residents.
                  <span class="moretext">They ensure that all the residents are kept clean, groomed and comfortable, and
                    make them feel content and valued. This meant so much to my mother, whom you all helped to feel her
                    best each day. The arrangement for the mobile doctor and his staff to come to see my mother was so
                    helpful. Nikky and the caregivers stayed on top of all the medication and health needs and took time
                    to communicate with me regarding any changes in her care. Nikky and her staff arrange for podiatry,
                    medication delivery, and other care needs. Nikky also provided support in selecting Hospice care and
                    worked together with them to provide the best level of care for my mother at the end of her life. I
                    would like to say thank you to Safe Harbor Elder Care for making the last two years of my mother's
                    life the best that it could be. You gave her dignity, respect, love, care, laughter and warmth. I
                    would like to say a special thank you to her caregiver, Molly who was very special to her and is to
                    all of us. <span><b>- Denise Ransweiler</b></span></span>
                </p>
                <button class="moreless-button d-flex mx-auto btn bg-blue text-white mt-2">Read more</button>
              </div>
            </div>
            <div class="testimonial">
              <div class="testimonial-content">
                <p class="description">
                  Dear Nikki and Gary, We thank you for caring for our father during his most difficult days. You and
                  your staff were by his side with sensitive, professional, and knowledgeable care at all times.
                  Eldercare is an immaculate, attractive, and highly responsive home. The courtyard is beautiful and
                  meals are served family style.
                  <span class="moretext">Caregivers encourage a true sense of community. Your collaboration with Dad’s
                    hospice organization, doctors, pharmacy, church and our family members, even during covid-19 was so
                    helpful to him. Thank you for creating FaceTime calls when Dad was his most energetic. You knew just
                    when he was up for them. Those moments were very meaningful to us. With warm regards and much
                    gratitude, Lisa Kehayias-Farhi and William Kehayias.
                    <span><b>- Lisa Farhi</b></span></span>

                </p>
                <button class="moreless-button d-flex mx-auto btn bg-blue text-white mt-2">Read more</button>
              </div>
            </div>
            <div class="testimonial">
              <div class="testimonial-content">
                <p class="description">
                  Safe Harbor Escondido has provided excellent care for my mother who has dementia. The care team and
                  owners are hands on and highly compassionate and skilled . They have become an extended family to mom
                  and our family. The property is beautiful and cozy and always very well taken care. <span
                    class="moretext">Mom is Spanish dominant and the team is bilingual which is one of the reasons I
                    chose to have her placed there. She is thriving and has continued to stay very happy and healthy. I
                    am very grateful to them for all they do for mom and all the residents! 💕 <span><b>- Sonia
                        Bland</b></span></span>

                </p>
                <button class="moreless-button d-flex mx-auto btn bg-blue text-white mt-2">Read more</button>
              </div>
            </div>
            <div class="testimonial">
              <div class="testimonial-content">
                <p class="description">
                  We learned about the elder care facility located at 135 S Tulip st around February 2024. We moved our
                  Mom from Coronado retirement village and very happy about that. Our Mom 86 years old started to leave
                  there from beginning of March . Since then we are feeling very comfortable about her . <span
                    class="moretext">All staff in the facility treats my Mom like a family member. We appreciate the
                    cleanliness , fresh food made from scratch , keeping her appointment times and medications. All the
                    staff are very friendly and helpful. Thank you very much for everything. <span><b>- Helen and Edward
                        Lopatinsky</b></span></span>

                </p>
                <button class="moreless-button d-flex mx-auto btn bg-blue text-white mt-2">Read more</button>
              </div>
            </div>
            <div class="testimonial">
              <div class="testimonial-content">
                <p class="description">
                  Excellent care!! Top notch care givers and owner. We could not ask for better care of my mother.
                  <span><b>- Mark Holstein </b></span>
                </p>
              </div>
            </div>


          </div>
        </div>
      </div>
    </div>


    <!-- success Stories -->
    <div class="container my-4 " id="testimonial">
      <h2 class="text-center text-blue pt-3 storiesTitle">Success Stories</h2>
      <div class="row mt-5">
        <div class=" col-md-12">
          <div id="testimonial-slider1" class="owl-carousel">
            <div class="testimonial">
              <div class="testimonial-content">
                <div
                  class="col-sm-6 col-md-12 d-sm-flex justify-content-center my-3 align-items-center py-4 story-card">
                  <div class="col-md-3">
                    <img src="images/CB.jpg" alt="senior care" class="rounded-2xl my-3 my-md-0" width="100%">
                  </div>
                  <div class="col-md-8 md-left-border">
                    <p>CB used to live in a big assisted living facility. He has no family or friends, and makes all his
                      decisions by himself and says he is his biggest advocate. He was not very keen on the idea of
                      moving to a smaller setting because he was not sure if it is a right fit for him. He took the
                      plunge and now says, he now has the family that he never had before. He enjoys going on walks,
                      participating in activities and loves the small intimate setting where all residents live like a
                      family. He has made strong bonds with caregivers as well as residents and considers us as his
                      family. </p>
                  </div>
                </div>
              </div>
            </div>
            <div class="testimonial">
              <div class="testimonial-content">
                <div
                  class="col-sm-6 col-md-12 d-sm-flex justify-content-center my-3 align-items-center py-4 story-card">
                  <div class="col-md-3">
                    <img src="images/CA.jpg" alt="senior care" class="rounded-2xl my-3 my-md-0" width="100%">
                  </div>
                  <div class="col-md-8 md-right-border">
                    <p>CA is one of our biggest success stories! She moved in with us about 4.5 years ago and was
                      severely depressed. She would go days without eating/drinking, would constantly cry and make no
                      eye contact with anyone. Her family told us that she has been the same way for the last 20+ years
                      since her husband passed. She also suffered a childhood trauma that she was very reluctant to
                      personal care. With a calm, peaceful and loving environment and consistency of care staff, CA has
                      come a long way. She is now always happy, smiling, making friends and participating in activities.
                      Her family has congratulated us over and over again for giving their mom a new life. They never
                      thought they would see their mom smiling again. We are very grateful to our wonderful staff who
                      have made a real life difference in our resident’s lives. </p>
                  </div>

                </div>
              </div>
            </div>
            <div class="testimonial">
              <div class="testimonial-content">
                <div
                  class="col-sm-6 col-md-12 d-sm-flex justify-content-center my-3 align-items-center py-4 story-card">
                  <div class="col-md-3">
                    <img src="images/SB.jpg" alt="senior care" class="rounded-2xl my-3 my-md-0" width="100%">
                  </div>
                  <div class="col-md-8 md-left-border">
                    <p>When SB first came to us, he was diagnosed with schizophrenia. He was very anxious, restless,
                      and mostly agitated. He was always looking to escape/ find a way out. At our facility, we
                      were able to provide him more 1 on 1 attention. We were able to spend time listening to him
                      and indulge in conversation about his past, his family and the things that were important to
                      him. He developed a bond of trust with our care staff and now he asks to be accompanied for
                      his walks outside. He still has moments where he misses his sister, however, he has enjoyed
                      participating in activities, forming bonds with other residents and the variety of food
                      offered at the facility.</p>
                  </div>
                </div>
              </div>
            </div>
            <div class="testimonial">
              <div class="testimonial-content">
                <div
                  class="col-sm-6 col-md-12 d-sm-flex justify-content-center my-3 align-items-center py-4 story-card">
                  <div class="col-md-3">
                    <img src="images/CD.jpg" alt="senior care" class="rounded-2xl my-3 my-md-0" width="100%">
                  </div>
                  <div class="col-md-8 md-right-border">
                    <p>CD had a traumatic experience before she came to us. She was dealing with a lot of bullying
                      behavior which had led her to become scared and was easily triggered. She was overly
                      paranoid and could not sleep. Her anxiety was uncontrollable. We worked hard developing a
                      bond with CD. In addition to this we worked closely with CD's psychiatrist in identifying
                      her symptoms and the medication that could help her. In a few weeks, as CD noticed the
                      constant people and environment around her, she started getting comfortable and was able to
                      relax. She now enjoys going grocery shopping with us. She likes to help with tasks such as
                      laundry, clearing out the table etc. She loves socializing and spending time with other
                      residents. And the best part is,she is now always smiling.</p>
                  </div>

                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
      <button class="moreless-button d-flex mx-auto btn bg-blue text-white mt-2"><a href="stories.html"
          class="text-white">View more</a></button>
    </div>


    <!-- locations -->
    <div class="cover2 overlay py-4 mt-0 mt-md-5"
      style="background-image: linear-gradient(rgba(60, 144, 247, 0.253), rgba(60, 144, 247, 0.219)), url(images/slider-2.jpg)"
      id="location">
      <div class="container">
        <h2 class="text-center text-white my-3">Locations</h2>
        <div class="row ">
          <div class="col-lg-12 mx-auto text-center align-self-center">
            <!-- <h1 class="mb-5 heading">Our Goal is to Make Your Life Better</h1> -->
            <div class="row">
              <div class="col-lg-3 col-md-4">
                <div class="card my-3">
                  <!-- <img class="card-img-top" src="images/location-img1.jpg" alt="Del-Cerro-Elder-care"> -->
                  <div class="card-body">
                    <h5 class="card-title">Del Cerro Elder Care</h5>
                    <p class="card-text-line mb-1">
                      <i class="fas fa-location-dot mr-2"></i>6288 Wenrich Dr., <br>San Diego, CA 92120
                    </p>
                    <p class="card-text mb-0"><i class="fas fa-phone"></i> (619) 877-1759</p>
                    <p class="card-text mt-2 liNumber-border">Facility #374604860</p>
                  </div>
                </div>
              </div>
              <div class="col-lg-3 col-md-4">
                <div class="card my-3">
                  <!-- <img class="card-img-top" src="images/location-img2.jpg" alt="El-Cajon-Elder-care"> -->
                  <div class="card-body">
                    <h5 class="card-title">El Cajon Elder Care</h5>
                    <p class="card-text-line mb-1">
                      <i class="fas fa-location-dot mr-2"></i>
                      1412 Groveland Terrace,<br>
                      El Cajon, CA 92021
                    </p>
                    <p class="card-text mb-0"><i class="fas fa-phone"></i> (619) 955-6008</p>
                    <p class="card-text mt-2 liNumber-border">Facility #374604796</p>
                  </div>
                </div>
              </div>
              <div class="col-lg-3 col-md-4">
                <div class="card my-3">
                  <!-- <img class="card-img-top" src="images/location-img3.jpg" alt="Escondido-Elder-care"> -->
                  <div class="card-body">
                    <h5 class="card-title">Escondido Elder Care</h5>
                    <p class="card-text-line mb-1">
                      <i class="fas fa-location-dot mr-2"></i>
                      135 S. Tulip St., <br> Escondido, CA 92025
                    </p>
                    <p class="card-text mb-0"><i class="fas fa-phone"></i> (619) 877-1818</p>
                    <p class="card-text mt-2 liNumber-border">Facility #371881424</p>
                  </div>
                </div>
              </div>
              <div class="col-lg-3 col-md-4">
                <div class="card my-3">
                  <!-- <img class="card-img-top" src="images/location-img4.jpg" alt="La-Mesa-Elder-care"> -->
                  <div class="card-body">
                    <h5 class="card-title">La Mesa Elder Care</h5>
                    <p class="card-text-line mb-1">
                      <i class="fas fa-location-dot mr-2"></i>
                      7784 Melotte St,<br>
                      San Diego, CA 92119
                    </p>
                    <p class="card-text mb-0"><i class="fas fa-phone"></i> (619) 877-2308</p>
                    <p class="card-text mt-2 liNumber-border">Facility #374604729</p>
                  </div>
                </div>
              </div>
              <div class="col-lg-3 col-md-4">
                <div class="card my-3">
                  <!-- <img class="card-img-top" src="images/location-img6.jpg" alt="Poway-Elder-care"> -->
                  <div class="card-body">
                    <h5 class="card-title">Poway <br> Elder Care</h5>
                    <p class="card-text-line mb-1">
                      <i class="fas fa-location-dot mr-2"></i>
                      14846 Espola Rd., <br>
                      Poway, CA 92064
                    </p>
                    <p class="card-text mb-0"><i class="fas fa-phone"></i> (858) 216-4190</p>
                    <p class="card-text mt-2 liNumber-border">Facility #374604485</p>
                  </div>
                </div>
              </div>

              <div class="col-lg-3 col-md-4">
                <div class="card my-3">
                  <!-- <img class="card-img-top" src="images/location-img5.jpg" alt="Point-Loma-Elder-care"> -->
                  <div class="card-body">
                    <h5 class="card-title">Point Loma <br> Elder Care</h5>
                    <p class="card-text-line mb-1">
                      <i class="fas fa-location-dot mr-2"></i>
                      3941 Liggett Dr.,<br>
                      San Diego, CA 92106
                    </p>
                    <p class="card-text mb-0"><i class="fas fa-phone"></i> (619) 255-6448</p>
                    <p class="card-text mt-2 liNumber-border">Facility #374604019</p>
                  </div>
                </div>
              </div>

              <div class="col-lg-3 col-md-4">
                <div class="card my-3">
                  <!-- <img class="card-img-top" src="images/location-img7.jpg" alt="Safe-Harbor-Elder-care"> -->
                  <div class="card-body">
                    <h5 class="card-title">Safe Harbor <br> Elder Care</h5>
                    <p class="card-text-line mb-1">
                      <i class="fas fa-location-dot mr-2"></i>
                      3301 Lomas Serenas Drive,<br>
                      Escondido, CA 92029
                    </p>
                    <p class="card-text mb-0"><i class="fas fa-phone"></i> (858) 935-8818</p>
                    <p class="card-text mt-2 liNumber-border">Facility #374604277</p>
                  </div>
                </div>
              </div>
              <div class="col-lg-3 col-md-4">
                <div class="card my-3">
                  <!-- <img class="card-img-top" src="images/location-img8.jpg" alt="Sunset-Cliffs-Elder-care"> -->
                  <div class="card-body">
                    <h5 class="card-title">Sunset Cliffs <br> Elder Care</h5>
                    <p class="card-text-line mb-1">
                      <i class="fas fa-location-dot mr-2"></i>
                      1039 Santa Barbara St.,<br>
                      San Diego, CA 92107
                    </p>
                    <p class="card-text mb-0"><i class="fas fa-phone"></i> (619) 877-2887</p>
                    <p class="card-text mt-2 liNumber-border">Facility #374604388</p>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>

    <!-- contact -->
    <div class="mt-5" id="contact">
      <h2 class="text-center text-blue pt-3">Contact Us</h2>
      <div class="container">
        <div class="row pt-5">
          <div class="col-lg-8 mb-5">
            <form action="send_form.php" method="post" onsubmit="return ValidmathCaptcha();" class="row g-4 form">
              <div class="col-md-6 my-4 form-group">
                <input type="text" name="name" class="form-control border-primary p-2" id="name" placeholder="Name" required="">
              </div>
              <!-- <div class="col-lg-4 col-md-6 form-group">
                                        <input autocomplete="off" type="number" placeholder="Number" name="number" class="form-control border-primary p-2" required="">
                                    </div> -->

              <div class="col-md-6 my-4 form-group">
                <input type="number" class="form-control border-primary p-2" name="number" id="number" placeholder="Contact No." required="">
              </div>
              <div class="col-12 my-4 form-group">
                <input type="email" class="form-control border-primary p-2" name="email" id="email" placeholder="Email" required="">
              </div>
              <div class="col-12 my-4 text-center">
                <textarea class="form-control border-primary p-2" id="exampleFormControlTextarea1" name="message" rows="3" cols="50" placeholder="Message" required="" style="height: 114px;"></textarea>
              </div>
              <!-- <div class="col-12 text-center">
                                        <button type="submit" class="btn btn-primary px-4 py-3 rounded-pill">Submit Now</button>
                                    </div> -->
              <div class="form-group d-md-flex captch-code" style="margin-bottom: 0;text-align: center;">
                <div class="col-md-6 padding-left-zero padding-right-zero total">
                  <label for="type_see" class="labels lcaptcha  text-dark" style="font-weight: 500; padding-top:6px;">What is
                    <span style="font-size: 22px;font-weight: 700;">
                      <?php
                      print $math;
                      ?></span>
                  </label>
                </div>

                <div class="col-sm-6 padding-left-zero padding-right-zero mt-2">
                  <input name="captcha" id="captcha" type="text" class="form-control border-primary p-2" required="required" autocomplete="off" placeholder="Total">

                </div>

              </div>
              <div class="col-md-6 submit">
                <fieldset>
                  <button type="submit" name="submit" class="btn btn-primary mt-5">Submit</button>
                </fieldset>
              </div>
              <!-- dummy firlds for bots start-->
              <!-- dummy firlds for bots start-->
              <div class="value-math">
                <label for="type_see">What is
                  <span>
                    <?php
                    print $d_math;
                    ?></span>
                </label>

                <input name="d_captcha" id="d_captcha" type="text" autocomplete="on">
                <input autocomplete="on" name="pass_math" type="text" value='<?php echo "$answer"; ?>'>
              </div>
            </form>
          </div>
          <div class="col-lg-3 ml-auto">
            <div class="mb-3">
              <!-- <p class="mb-0 font-weight-bold text-black">Address</p>
              <p class="mb-4">????????????</p> -->

              <p class="mb-1 font-weight-bold text-black">Phone</p>
              <p class="mb-1"><a href="#">(619) 791-5495</a></p>
              <p class="mb-1"><a href="#">(480) 286-0552</a></p>
              <p class="mb-4"><a href="#">(419) 377-9822</a></p>

              <p class="mb-1 font-weight-bold text-black">Fax</p>
              <p class="mb-4"><a href="#">(619) 374-2720</a></p>

              <p class="mb-0 font-weight-bold text-black">Email Address</p>
              <p class="mb-0"><a href="#">sandiegoeldercare@gmail.com</a></p>

            </div>

          </div>
        </div>
      </div>
    </div>


    <!-- <div class="nav flex-row nav-pills" id="v-pills-tab" role="tablist" aria-orientation="vertical">
      <a class="nav-link active" id="v-pills-home-tab" data-toggle="pill" href="#v-pills-home" role="tab" aria-controls="v-pills-home" aria-selected="true">Home</a>
      <a class="nav-link" id="v-pills-profile-tab" data-toggle="pill" href="#v-pills-profile" role="tab" aria-controls="v-pills-profile" aria-selected="false">Profile</a>
      <a class="nav-link" id="v-pills-messages-tab" data-toggle="pill" href="#v-pills-messages" role="tab" aria-controls="v-pills-messages" aria-selected="false">Messages</a>
      <a class="nav-link" id="v-pills-settings-tab" data-toggle="pill" href="#v-pills-settings" role="tab" aria-controls="v-pills-settings" aria-selected="false">Settings</a>
    </div>
    <div class="tab-content" id="v-pills-tabContent">
      <div class="tab-pane fade show active" id="v-pills-home" role="tabpanel" aria-labelledby="v-pills-home-tab">Lorem ipsum dolor sit amet consectetur adipisicing elit. Blanditiis, quisquam?</div>
      <div class="tab-pane fade" id="v-pills-profile" role="tabpanel" aria-labelledby="v-pills-profile-tab">Lorem ipsum </div>
      <div class="tab-pane fade" id="v-pills-messages" role="tabpanel" aria-labelledby="v-pills-messages-tab">consectetur adipisicing elit. Blanditiis, quisquam?</div>
      <div class="tab-pane fade" id="v-pills-settings" role="tabpanel" aria-labelledby="v-pills-settings-tab">adipisicing elit. Blanditiis, quisquam?</div>
    </div> -->


    <!-- <div class="site-section">
      <div class="container">
        <div class="row mb-5 justify-content-center">
          <div class="col-7 text-center">
            <div class="heading">
              <h2 class="text-black">Other Opportunities</h2>
            </div>
            <p>Lorem ipsum dolor sit amet, consectetur adipisicing elit. Modi, culpa.</p>
          </div>
        </div>
        <div class="row">
          <div class="col-lg-6 mb-4">
            <div class="d-block d-flex custom-media algin-items-stretch">
              <div class="text text-left">
                <h3>You can live here with love</h3>
                <p class="mb-4">Lorem ipsum dolor sit amet, consectetur adipisicing elit. Quae, commodi.</p>
                <p><a href="#" class="btn btn-outline-white">Learn More</a></p>
              </div>
              <div class="img-bg" style="background-image: url('images/img_2.jpg')"></div>
            </div>
          </div>
          <div class="col-lg-6 mb-4">
            <div class="d-block d-flex custom-media algin-items-stretch">
              <div class="text text-left">
                <h3>You can live here with love</h3>
                <p class="mb-4">Lorem ipsum dolor sit amet, consectetur adipisicing elit. Quae, commodi.</p>
                <p><a href="#" class="btn btn-outline-white">Learn More</a></p>
              </div>
              <div class="img-bg" style="background-image: url('images/img_3.jpg')"></div>
            </div>
          </div>
        </div>
      </div>
    </div> -->

    <!-- footer -->
    <div class="site-footer">
      <div class="container text-center">
        <h2 class="footer-heading mb-4"><b>San Diego Elder Care</b></h2>
        <p class="col-md-7 mx-auto mb-4">Our philosophy at San Diego Elder Care is simple – provide personalized,
          upscale, and resident-centered care in order to meet individual preferences and needs.</p>
        <ul class="list-unstyled d-sm-flex justify-content-center">
          <li class="px-2 px-lg-3 border-right border-dark"><a href="index.php">Home</a></li>
          <li class="px-2 px-lg-3 border-right border-dark"><a href="about.html">About Us</a></li>
          <li class="px-2 px-lg-3 border-right border-dark"><a href="#service">Services</a></li>
          <li class="px-2 px-lg-3 border-right border-dark"><a href="gallery.html#gallery">Gallery</a></li>
          <li class="px-2 px-lg-3 border-right border-dark"><a href="#testimonial">Testimonials</a></li>
          <li class="px-2 px-lg-3 border-right border-dark"><a href="stories.html#story">Success Stories</a></li>
          <li class="px-2 px-lg-3 border-right border-dark"><a href="#location">Locations</a></li>
          <li class="px-2 px-lg-3"><a href="#contact">Contact Us</a></li>
        </ul>
        <div class="row text-center">
          <div class="col-md-12">
            <div class="border-top pt-2">
              <p class="copyright"><small>
                  Copyright &copy; 2024 All rights reserved </p>
            </div>
          </div>
        </div>

      </div>
    </div>
  </div>




  <!-- Optional JavaScript -->
  <!-- jQuery first, then Popper.js, then Bootstrap JS -->
  <script src="https://code.jquery.com/jquery-3.2.1.slim.min.js"
    integrity="sha384-KJ3o2DKtIkvYIK3UENzmM7KCkRr/rE9/Qpg6aAZGJwFDMVNA/GpGFF93hXpG5KkN"
    crossorigin="anonymous"></script>
  <script src="https://cdn.jsdelivr.net/npm/popper.js@1.12.9/dist/umd/popper.min.js"
    integrity="sha384-ApNbgh9B+Y1QKtv3Rn7W3mgPxhU9K/ScQsAP7hUibX39j7fakFPskvXusvfa0b4Q"
    crossorigin="anonymous"></script>
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@4.0.0/dist/js/bootstrap.min.js"
    integrity="sha384-JZR6Spejh4U02d8jOt6vLEHfe/JQGiRRSQQxSfFWpi1MquVdAyjUar5+76PVCmYl"
    crossorigin="anonymous"></script>
  <!-- owl carousel -->
  <script type="text/javascript" src="https://code.jquery.com/jquery-1.12.0.min.js"></script>
  <script type="text/javascript"
    src="https://cdnjs.cloudflare.com/ajax/libs/owl-carousel/1.3.3/owl.carousel.min.js"></script>


  <!-- click nav item and add active class -->
  <script>
    document.addEventListener('DOMContentLoaded', function() {
      // Get all nav links
      var navLinks = document.querySelectorAll('.navbar-nav .nav-link');

      // Function to handle the click event
      function setActiveLink(event) {
        // Remove active class from all links
        navLinks.forEach(function(link) {
          link.classList.remove('active');
        });

        // Add active class to the clicked link
        event.currentTarget.classList.add('active');
      }

      // Attach click event listeners to all nav links
      navLinks.forEach(function(link) {
        link.addEventListener('click', setActiveLink);
      });

      // Optional: Set the initial active link based on the current URL
      var currentUrl = window.location.href;
      navLinks.forEach(function(link) {
        if (currentUrl.includes(link.getAttribute('href'))) {
          link.classList.add('active');
        }
      });
    });
  </script>

  <!-- click outside to hide navbar -->
  <script>
    document.addEventListener('click', function(event) {
      const isClickInsideNavbar = document.getElementById('navbarCollapse').contains(event.target);
      const navbarCollapse = document.getElementById('navbarCollapse');

      if (!isClickInsideNavbar && navbarCollapse.classList.contains('show')) {
        navbarCollapse.classList.remove('show');
      }
    });
  </script>

  <!-- testimonial -->
  <script>
    $(document).ready(function() {
      $("#testimonial-slider").owlCarousel({
        items: 3,
        itemsDesktop: [1000, 1],
        itemsDesktopSmall: [990, 1],
        itemsTablet: [768, 1],
        itemsMobile: [650, 1],
        pagination: true,
        navigation: false,
        autoPlay: true
      });
    });
  </script>


  <!-- stories slider -->
  <script>
    $(document).ready(function() {
      $("#testimonial-slider1").owlCarousel({
        items: 1,
        itemsDesktop: [1000, 1],
        itemsDesktopSmall: [990, 1],
        itemsTablet: [768, 1],
        itemsMobile: [650, 1],
        pagination: true,
        navigation: false,
        autoPlay: true
      });
    });
  </script>

  <!-- read more read less -->
  <script>
    document.addEventListener("DOMContentLoaded", function() {
      const moreButtons = document.querySelectorAll('.moreless-button');

      moreButtons.forEach(button => {
        button.addEventListener('click', function() {
          // Get the corresponding moretext element
          const moreText = this.parentElement.querySelector('.moretext');

          // If moreText is not null, toggle its visibility
          if (moreText) {
            if (moreText.style.display === 'none' || moreText.style.display === '') {
              // Hide all other moretext elements
              const allMoreTexts = document.querySelectorAll('.moretext');
              allMoreTexts.forEach(text => {
                text.style.display = 'none';
              });

              // Change all buttons back to "Read more"
              moreButtons.forEach(btn => {
                btn.textContent = 'Read more';
              });

              // Show the clicked moreText
              moreText.style.display = 'inline'; // or 'block' based on your layout
              this.textContent = 'Read less';
            } else {
              // Hide the clicked moreText
              moreText.style.display = 'none';
              this.textContent = 'Read more';
            }
          }
        });
      });
    });
  </script>

  <!-- gallery -->
  <script>
    $(document).ready(function() {
      // Show overlay on button click
      $("[unique-script-id='w-w-dm-id'] .btn-box").click(function(event) {
        event.stopPropagation(); // Prevent the click event from bubbling up
        $(this).parent().children(".overlay2").show();
      });

      // Close overlay when clicking on the close button
      $("[unique-script-id='w-w-dm-id'] .close").click(function(event) {
        event.stopPropagation(); // Prevent the click event from bubbling up
        $(this).closest(".overlay2").hide();
      });

      // Close overlay when clicking outside the overlay-inner
      $(document).click(function(event) {
        if (!$(event.target).closest('.overlay-inner').length) {
          $(".overlay2").hide();
        }
      });

      // Filter functionality
      $("[unique-script-id='w-w-dm-id'] .list").click(function() {
        const value = $(this).attr('data-filter');
        if (value == 'all') {
          $("[unique-script-id='w-w-dm-id'] .squareImg").show();
        } else {
          $("[unique-script-id='w-w-dm-id'] .squareImg").not('.' + value).hide();
          $("[unique-script-id='w-w-dm-id'] .squareImg").filter('.' + value).show();
        }
      });

      // Set active class for filter buttons
      $("[unique-script-id='w-w-dm-id'] .list").click(function() {
        $(this).addClass('active').siblings().removeClass('active');
      });
    });
  </script>

  <!-- navbar bg color change when scroll -->
  <!-- <script>
    window.addEventListener('scroll', function () {
      const navbar = document.getElementById('navbar');
      const navLinks = document.querySelectorAll('.nav-link');

      if (window.scrollY > 50) {
        navbar.classList.add('bg-light');
        navbar.classList.remove('navbar-light');
        navLinks.forEach(link => link.classList.add('text-dark')); // Add class to change link color
      } else {
        navbar.classList.remove('bg-light');
        navbar.classList.add('navbar-light');
        navLinks.forEach(link => link.classList.remove('text-dark')); // Remove class
      }
    });

    // Hide navbar on nav link click for specific viewport sizes
    document.querySelectorAll('.nav-link').forEach(link => {
      link.addEventListener('click', function () {
        if (window.innerWidth >= 320 && window.innerWidth <= 768) {
          const navbarCollapse = document.getElementById('navbarCollapse');
          // Hide navbar by collapsing
          navbarCollapse.classList.remove('show');
        }
      });
    });



  </script> -->



</body>

</html>