<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1" />
    <title>Taste Of Excellence</title>

    <!-- Favicon -->
    <link rel="shortcut icon" href="images/main-logo.png" type="image/x-icon">
    <link rel="icon" href="images/main-logo.png" type="image/x-icon">

    <!-- bootstrap -->
    <link rel="stylesheet" type="text/css" href="css/bootstrap.min.css" />

    <!-- animate -->
    <link
        rel="stylesheet"
        href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css" />

    <!-- owl-carousel -->
    <link rel="stylesheet" type="text/css" href="css/owl.carousel.css">

    <!-- fontawesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.6.0/css/all.min.css"
        integrity="sha512-Kc323vGBEqzTmouAECnVceyQqyqdsSiqLQISBL29aUW4U/M7pSPA/gEUZQqv1cwx4OnYxTxve5UMg5GT6L4JJg=="
        crossorigin="anonymous" referrerpolicy="no-referrer" />

    <!-- shortcodes -->
    <link rel="stylesheet" type="text/css" href="css/shortcodes.css" />

    <!-- main -->
    <link rel="stylesheet" type="text/css" href="css/main.css" />

    <!-- responsive -->
    <link rel="stylesheet" type="text/css" href="css/responsive.css" />

</head>

<style>
    .value-math {
        opacity: 0;
        height: 0;
    }
</style>

<script type='text/javascript'>
    <?php
    $n1 = rand(1, 9); //Generate First number between 1 and 6  
    $n2 = rand(1, 9); //Generate Second number between 5 and 9  
    $answer = $n1 + $n2;
    $math = $n1 . " + " . $n2 . " : ";
    $_SESSION['vercode'] = $answer;


    /*dummy field value*/
    $d_n1 = rand(1, 9); //Generate First number between 1 and 6  
    $d_n2 = rand(1, 9); //Generate Second number between 5 and 9  
    $d_answer = $d_n1 + $d_n2;
    $d_math = $d_n1 . " + " . $d_n2 . " : ";
    /* $_SESSION['vercode'] = $d_answer;*/

    ?>

    function ValidmathCaptcha() {

        var captcha = document.getElementById('captcha').value;
        var value = '<?php echo $answer; ?>';
        if (captcha !== value) {
            alert("Please Enter correct captcha Value");
            event.preventDefault();
            document.getElementById('captcha').value = ""
        }
    }
</script>

<body>

    <!--page start-->
    <div class="page">


        <!--header start-->
        <header id="masthead" class="header ttm-header-style-01">
            <!-- ttm-header-wrap -->
            <div class="ttm-header-wrap">
                <!-- ttm-stickable-header-w -->
                <div id="ttm-stickable-header-w" class="ttm-stickable-header-w clearfix">
                    <div id="site-header-menu" class="site-header-menu">
                        <div class="site-header-menu-inner ttm-stickable-header">
                            <div class="container">
                                <div class="row">
                                    <div class="col-12">
                                        <!--site-navigation -->
                                        <div id="site-navigation" class="site-navigation">
                                            <div class="site-branding">
                                                <!-- site-branding -->
                                                <a class="home-link" href="index.php" title="Italian Food" rel="home">
                                                    <img id="logo-img" class="img-center lazyload"
                                                        src="images/main-logo.png" alt="logo">
                                                    <img class="logo-shape" src="images/logo-shape.png"
                                                        alt="logo-shape">
                                                </a>
                                                <!-- site-branding end -->
                                            </div>
                                            <div class="ttm-menu-toggle">
                                                <input type="checkbox" id="menu-toggle-form" />
                                                <label for="menu-toggle-form" class="ttm-menu-toggle-block">
                                                    <span class="toggle-block toggle-blocks-1"></span>
                                                    <span class="toggle-block toggle-blocks-2"></span>
                                                    <span class="toggle-block toggle-blocks-3"></span>
                                                </label>
                                            </div>
                                            <nav id="menu" class="menu">
                                                <ul class="dropdown" id="dropdown">
                                                    <li class="active"><a href="index.php">Home</a></li>
                                                    <li class=""><a href="#about">About Us</a></li>
                                                    <li><a href="menu.html">Catering Menu</a></li>
                                                    <li><a href="gallery.html">Gallery</a></li>
                                                    <li><a href="#contact" style="font-size: 25px;">Contact</a></li>

                                                </ul>
                                            </nav>
                                        </div><!-- site-navigation end-->
                                    </div>
                                </div>

                            </div>
                        </div>
                    </div>
                </div><!-- ttm-stickable-header-w end-->
            </div><!--ttm-header-wrap end -->
        </header><!--header end-->

        <!-- first section -->
        <div class="container-fluid section1">
            <div class="mt-100 animate__animated animate__fadeIn">
                <h1 style="color: #7a0b00;">Jesse's Kitchen</h1>
                <h3 class="text-dark" style="color: #0c1829;">The Best <span class="text-golden">Indian and Italian</span> Tasting Experience</h3>
                <h2 class="mb-0 sitename">Taste Of Excellence</h2>
            </div>
        </div>

        <!--site-main start-->
        <div class="site-main">
            <div class="ttm-bg ttm-bgimage-yes">
                <div class="ttm-row-wrapper-bg-layer ttm-bg-layer"></div>
                <!-- first section -->
                <section class="ttm-row zero-padding-section position-relative bg-layer-equal-height z-1 clearfix">
                    <div class="container res-767-p-15">
                        <div
                            class="row no-gutters mt_35 ttm-bgcolor-white box-shadow2 ttm-row-expand-rightfull res-1199-mt_0">
                            <div class="col-md-4">
                                <!-- col-img-img-one -->
                                <div class="col-bg-img-one ttm-col-bgimage-yes ttm-bg res-767-h-auto">
                                    <div class="ttm-col-wrapper-bg-layer ttm-bg-layer"></div>
                                </div><!-- col-img-bg-img-one end-->
                                <img src="images/chef.jpeg" class="ttm-equal-height-image img-fluid" alt="bg-image">
                            </div>
                            <div class="col-md-8 res-767-pt-15">
                                <!--  featured-icon-box -->
                                <div class="featured-icon-box icon-align-before-content icon-ver_align-top style1">
                                    <div class="featured-content"><!--  featured-content -->
                                        <div class="featured-desc"><!--  featured-desc -->
                                            <p>Jesse has <b>25 years</b> of restaurant management and Indian and Italian catering experience. As a professional chef, he specializes in creating exquisite dishes that highlight the best of both cuisines. Jesse takes pride in offering a mouth-watering selection of Indian and Italian dishes, paired with a fine selection of bar drinks.</p>
                                            <p>He is skilled in catering for weddings, office events, birthdays, anniversaries, house parties, and other memorable gatherings. Let us help you make your next event truly exceptional! Visit tasteofexcellence.com to explore catering options for your next special occasion. </p>
                                        </div>
                                    </div>
                                </div><!--  featured-icon-box END -->
                            </div>

                        </div>
                    </div>
                </section>
                <!-- about -->
                <section class="ttm-row service-section clearfix" id="about">
                    <div class="container pb-90 pt-80">
                        <!-- row end -->
                        <div class="site-main">
                            <!-- about weare-section -->
                            <section class="about-weare-section clearfix">
                                <div class="container">
                                    <div class="row"><!-- row -->
                                        <div class="col-md-6 col-lg-4 text-center res-767-center res-767-pt-15">
                                            <img src="images/jassi.png" class="img-fluid res-767-m-auto" alt="bg-image">
                                            <h2 class="mb-0">Jesse Garg</h2>
                                            <p>General Manager and Executive Chef</p>
                                        </div>
                                        <div class="col-md-6 col-lg-8 res-991-mt-0">
                                            <!-- section title -->
                                            <div class="section-title with-desc clearfix">
                                                <h2 class="title pb-20 text-center text-lg-left">About Us</h2>
                                                <p>Jesse Garg came to the United States of America about two decades
                                                    ago from the Northern part of India. He has had a passion of
                                                    cooking since he was seven years old because he grew up watching
                                                    his father cook, as a chef. He learned from his father’s shared
                                                    recipes and cooking skills. His father always had a dream to
                                                    open a pub or a restaurant in the United States. Therefore, this
                                                    was always a goal for Jesse; to fulfill his father’s dream.
                                                    Jesse Garg Started his restaurant career working at Grinders
                                                    restaurant as General Manager. In over 20 years of his
                                                    restaurant career, Jesse worked as a Culinary Manager, Service
                                                    Manager and General Manager of HomeTown Buffet, Grinders
                                                    restaurant, and Olive Garden restaurant, one of largest family
                                                    Italian restaurant chain.</p>

                                                <p>Jesse Garg also helped his wife to open their first Indian
                                                    restaurant in San Marcos, San Diego and branched out the Indian
                                                    restaurant and open more restaurants in Carlsbad, San Marcos,
                                                    and Temecula. This way he fulfilled his father’s dream. Jesse is
                                                    passionate about his service and cooking skills. He is a
                                                    professional Northern Indian restaurant Master Chef and still
                                                    creates flavorful recipes for his restaurants and catering
                                                    patrons. He also got invited by television morning show Channel
                                                    8 of San Diego to perform his cooking skills, where he displays
                                                    the cooking tips for one his signature Dish recipe.</p>
                                                <p>Due to his love of restaurant & hospitality business industry;
                                                    and experienced culinary manager of one of the largest chain of
                                                    Italian restaurants, Jesse has decided to join a group of
                                                    entrepreneurs to open Italian restaurants. As a General Manager
                                                    and Executive Chef, Jesse is opening his own First Italian
                                                    restaurant, La Cucina in Fallbrook, CA.</p>
                                            </div>
                                        </div><!-- section title end -->
                                    </div>
                                </div>
                        </div>
                </section>
                <!-- about weare-section end -->
            </div><!--site-main end-->
        </div>
        </section>
    </div>

    <!-- services -->
    <div class="">
        <div class="section-title with-desc text-center clearfix">
            <div class="title-header">
                <!-- <h5 class="ttm-textcolor-rescolor">Welcome</h5> -->
                <h2 class="title pt-40 pb-40">Our Services</h2>
            </div>
        </div>
        <div class="service12">
            <div class="service12--wrapper">
                <div class="service12--item">
                    <figure class="service-figure">
                        <img src="images/service1.jpg" alt="" />
                        <div class="overlay">
                            <h2 class="text-white d-flex justify-content-center align-items-center">Wedding</h2>
                        </div>
                    </figure>
                </div>

                <div class="service12--item">
                    <figure class="service-figure">
                        <img src="images/service2.jpg" alt="" />
                        <div class="overlay">
                            <h2 class="text-white d-flex justify-content-center align-items-center">Office Events</h2>
                        </div>
                    </figure>
                </div>

                <div class="service12--item">
                    <figure class="service-figure">
                        <img src="images/service3.jpg" alt="" />
                        <div class="overlay">
                            <h2 class="text-white d-flex justify-content-center align-items-center">Birthday's</h2>
                        </div>
                    </figure>
                </div>

                <div class="service12--item">
                    <figure class="service-figure">
                        <img src="images/service4.jpg" alt="" />
                        <div class="overlay">
                            <h2 class="text-white d-flex justify-content-center align-items-center">Anniversary</h2>
                        </div>
                    </figure>
                </div>
                <div class="service12--item">
                    <figure class="service-figure">
                        <img src="images/service5.jpg" alt="" />
                        <div class="overlay">
                            <h2 class="text-white d-flex justify-content-center align-items-center">House Party</h2>
                        </div>
                    </figure>
                </div>
                <div class="service12--item">
                    <figure class="service-figure">
                        <img src="images/service6.jpg" alt="" />
                        <div class="overlay">
                            <h2 class="text-white text-center">Special Occasions</h2>
                        </div>
                    </figure>
                </div>
            </div>

        </div>
    </div>

    <div class="d-flex justify-content-between mt-sm-40">
        <button class="prev">Previous</button>
        <button class="next">Next</button>
    </div>


    <!-- our menu -->
    <section class="ttm-row pricelist-section mt-100 bg-layer-equal-height res-767-p-0 ttm-bg ttm-bgimage-yes">
        <div class="ttm-row-wrapper-bg-layer ttm-bg-layer"></div>
        <div class="container">
            <div class="row price-wrapper ">
                <div class="col-12">
                    <h2 class="title text-center pb-40">Our Catering Menu</h2>
                    <div class="row no-gutters box-shadow ttm-bgcolor-white">
                        <div class="col-md-6">
                            <!-- col-img-img-two -->
                            <div class="col-bg-img-two ttm-col-bgimage-yes ttm-bg res-767-h-auto">
                                <div class="ttm-col-wrapper-bg-layer ttm-bg-layer"></div>
                            </div><!-- col-img-bg-img-two end-->
                            <img src="images/menubg1.jpg" class="ttm-equal-height-image img-fluid ourmenuimg"
                                alt="bg-image">
                        </div>
                        <div class="col-md-6">
                            <div class="spacing-2">
                                <div class="ttm-pricelist-block-wrapper">
                                    <ul class="ttm-pricelist-block p-0">
                                        <li>Vegetable Samosa (lg)</li>
                                        <li>Vegetable Samosa (sm)</li>
                                        <li>Chilli Pakora</li>
                                        <li>Veg Cutlet</li>
                                    </ul> <!-- .tm-pricelist-block -->
                                </div>
                            </div>
                        </div>
                    </div>
                    <div
                        class="row no-gutters box-shadow ttm-bgcolor-white res-767-d-flex-reverse res-767-mt-15 res-767-mb-40">
                        <div class="col-md-6">
                            <div class="spacing-2">
                                <div class="ttm-pricelist-block-wrapper">
                                    <ul class="ttm-pricelist-block p-0">
                                        <li> Chicken Alfredo</li>
                                        <li>Spaghetti with Marinara</li>
                                        <li>Fettuccine Alfredo</li>
                                        <li>Spaghetti with Meatballs</li>
                                    </ul> <!-- .tm-pricelist-block -->
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <!-- col-img-img-two -->
                            <div class="col-bg-img-three ttm-col-bgimage-yes ttm-bg res-767-h-auto">
                                <div class="ttm-col-wrapper-bg-layer ttm-bg-layer"></div>
                            </div><!-- col-img-bg-img-two end-->
                            <img src="images/ourmenuimg2.jpg" class="ttm-equal-height-image img-fluid ourmenuimg"
                                alt="bg-image">
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="text-center mt-40">
            <a href="menu.html"><button type="submit" id="submit"
                    class="ttm-btn ttm-btn-size-md ttm-textcolor-white ttm-btn-bgcolor-rescolor"
                    value="">
                    View Full Menu
                </button></a>
        </div>
    </section>

    <!-- gallery  -->
    <section class="ttm-row instagram-section" id="gallery">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12 text-center">
                    <!-- <h3>Gallery</h3> -->
                    <div class="gal-images d-sm-flex">
                        <div class="gal-image-item" onclick="openModal(this)">
                            <img class="img-fluid" src="images/g.jpeg" alt="Italian food" width="200">
                        </div>
                        <div class="gal-image-item" onclick="openModal(this)">
                            <img class="img-fluid" src="images/gallery/g2.jpg" alt="Italian food" width="200">
                        </div>
                        <div class="gal-image-item" onclick="openModal(this)">
                            <img class="img-fluid" src="images/gallery/g3.jpeg" alt="Italian food" width="200">
                        </div>
                        <div class="gal-image-item" onclick="openModal(this)">
                            <img class="img-fluid" src="images/gallery/g4.jpg" alt="Italian food" width="200">
                        </div>
                        <div class="gal-image-item" onclick="openModal(this)">
                            <img class="img-fluid" src="images/gallery/g5.jpeg" alt="Italian food" width="200">
                        </div>
                        <div class="gal-image-item" onclick="openModal(this)">
                            <img class="img-fluid" src="images/gallery/g6.jpeg" alt="Italian food" width="200">
                        </div>
                    </div>

                    <!-- Modal -->
                    <div id="modal" class="modal" onclick="closeModal()">
                        <span class="close" onclick="closeModal()">&times;</span>
                        <img class="modal-content" id="modalImage">
                    </div>

                </div>
            </div>
        </div>
    </section>

    <!-- contact -->
    <section class="contact py-5" id="contact">
        <div class="container px-md-5">
            <div class="row align-items-center">
                <div class="col-md-7 text-white mx-auto">
                    <h2 class="title text-center">Contact</h2>

                    <form action="send_form.php" method="post" onsubmit="return ValidmathCaptcha();" class="py-4">
                        <div class="row">
                            <div class="col-md-6 form-group">
                                <input type="text" name="name" class="form-control" id="name" placeholder="Your Name" required="">
                            </div>
                            <div class="col-md-6 form-group mt-3 mt-md-0">
                                <input type="email" class="form-control" name="email" id="email" placeholder="Your Email" required="">
                            </div>
                        </div>
                        <div class="form-group mt-3">
                            <input type="number" class="form-control" name="number" id="number" placeholder="Your Number" required="">
                        </div>
                        <div class="form-group mt-3">
                            <textarea class="form-control" name="message" rows="5" placeholder="Message" required=""></textarea>
                        </div>
                        <!-- <button type="submit" class="btn btn-outline-warning my-4 my-md-3">Submit</button> -->
                        <div class="form-group d-md-flex captch-code" style="margin-bottom: 0;text-align: center;">
                            <div class="col-md-6 padding-left-zero padding-right-zero total">
                                <label for="type_see" class="labels lcaptcha text-dark" style="font-weight: 500; padding-top:6px;">What is
                                    <span style="font-size: 22px;font-weight: 700;">
                                        <?php
                                        print $math;
                                        ?></span>
                                </label>
                            </div>

                            <div class="col-sm-6 padding-left-zero padding-right-zero mt-2">
                                <input name="captcha" id="captcha" type="text" class="form-control" required="required" autocomplete="off" placeholder="Total">

                            </div>

                        </div>
                        <div class="col-md-6 submit">
                            <fieldset>
                                <button type="submit" name="submit" class="ttm-btn ttm-btn-size-md ttm-textcolor-white ttm-btn-bgcolor-rescolor">Submit</button>
                            </fieldset>
                        </div>
                        <!-- dummy firlds for bots start-->
                        <!-- dummy firlds for bots start-->
                        <div class="value-math">
                            <label for="type_see">What is
                                <span>
                                    <?php
                                    print $d_math;
                                    ?></span>
                            </label>

                            <input name="d_captcha" id="d_captcha" type="text" autocomplete="on">
                            <input autocomplete="on" name="pass_math" type="text" value='<?php echo "$answer"; ?>'>
                        </div>
                    </form>

                </div>

            </div>
        </div>
    </section>
    <!-- contact-section end-->

    </div><!--site-main end-->

    <!--footer start-->
    <footer class="footer widget-footer clearfix">
        <div class="second-footer ttm-textcolor-white">
            <div class="container">
                <div class="row">
                    <div class="col-xs-12 col-sm-12 col-md-12 col-lg-6 widget-area">
                        <div class="widget widget_text clearfix">
                            <h3 class="widget-title text-white">About Us</h3>
                            <div class="textwidget widget-text">
                                <p class="pb-2 mb-2 res-767-p-0">Jesse Garg came to the United States of America
                                    about two decades ago from the Northern part of India.
                                </p>
                                <p class="pb-10 res-767-p-0">He has had a passion of cooking since he was seven
                                    years old because he grew up watching his father cook, as a chef. He learned
                                    from his father’s shared recipes and cooking skills.</p>
                                <a class="ttm-color-rescolor" href="#about" title="">Read More</a>
                            </div>
                        </div>
                    </div>
                    <div class="col-xs-12 col-sm-12 col-md-6 col-lg-3 widget-area">
                        <div class="widget widget_text clearfix">
                            <h3 class="widget-title text-white">Links</h3>
                            <ul class="">
                                <li class="p-1">
                                    <a href="index.php">Home</a>
                                </li>
                                <li class="p-1">
                                    <a href="#about">About Us</a>
                                </li>
                                <li class="p-1">
                                    <a href="menu.html">Catering Menu</a>
                                </li>
                                <li class="p-1">
                                    <a href="gallery.html">Gallery</a>
                                </li>
                                <li class="p-1">
                                    <a href="#contact">Contact</a>
                                </li>
                            </ul>
                        </div>
                    </div>
                    <div class="col-xs-12 col-sm-12 col-md-6 col-lg-3 widget-area">
                        <div class="widget flicker_widget clearfix">
                            <h3 class="widget-title text-white">Get In Touch</h3>
                            <div class="textwidget widget-text">
                                <div class="featured-icon-box icon-align-before-content icon-ver_align-top style3">
                                    <div class="featured-icon">
                                        <div
                                            class="ttm-icon ttm-icon_element-onlytxt ttm-icon_element-color-rescolor ttm-icon_element-size-sm">
                                            <i class="fas fa-envelope"></i>
                                        </div>
                                    </div>
                                    <div class="featured-content">
                                        <div class="featured-desc">
                                            <p><a
                                                    href="mailto:gm.jessegarg31@gmail.com">
                                                    gm.jessegarg31@gmail.com</a>
                                            </p>
                                        </div>
                                    </div>
                                </div>
                                <div class="featured-icon-box icon-align-before-content icon-ver_align-top style3">
                                    <div class="featured-icon">
                                        <div
                                            class="ttm-icon ttm-icon_element-onlytxt ttm-icon_element-color-rescolor ttm-icon_element-size-sm">
                                            <i class="fa fa-phone"></i>
                                        </div>
                                    </div>
                                    <div class="featured-content">
                                        <div class="featured-desc">
                                            <p>(760)583-8875</p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="bottom-footer-text">
            <div class="container">
                <div class="row copyright">
                    <div class="col-md-9">
                        <div class="footer-last">
                            <span>Copyrights @ Taste Of Excellence <a href="https://www.appbell.com/">Development By Appbell Technologies Pvt. Ltd.</a> </span>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="d-flex flex-row align-items-center justify-content-end social-icons">
                            <ul class="social-icons list-inline">
                                <li><a href="https://www.facebook.com/people/La-Cucina-Trattoria/100088617965749/"
                                        class=" tooltip-top" data-tooltip="Facebook" target="_blank"><i
                                            class="fa-brands fa-facebook text-white"></i></a>
                                </li>
                                <li><a href="https://www.instagram.com/la_cucina_trattoria/" class=" tooltip-top"
                                        data-tooltip="instagram" target="_blank"><i
                                            class="fab fa-instagram text-white"></i></i></a>
                                </li>
                                <!-- <li><a href="https://twitter.com/PreyanTechnosys" class=" tooltip-top"
                                            data-tooltip="Twitter" target="_blank"><i class="fa fa-twitter"></i></a>
                                    </li>
                                    <li><a href="https://www.linkedin.com/in/preyan-technosys-pvt-ltd/"
                                            class=" tooltip-top" data-tooltip="Linkedin" target="_blank"><i
                                                class="fa fa-linkedin"></i></a>
                                    </li> -->
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </footer>
    <!--footer end-->

    <!--back-to-top start-->
    <a id="totop" href="#top">
        <i class="fa fa-angle-up"></i>
    </a>
    <!--back-to-top end-->

    </div><!-- page end -->

    <!-- Javascript -->


    <script src="https://cdnjs.cloudflare.com/ajax/libs/gsap/3.4.2/gsap.min.js"></script>
    <script>
        /*--------------------
        Vars
        --------------------*/
        const $service = document.querySelector('.service12');
        const $items = document.querySelectorAll('.service12--item');
        const $images = document.querySelectorAll('.service12--item img');
        let serviceWidth = $service.clientWidth;
        let itemWidth = $items[0].clientWidth;
        let wrapWidth = $items.length * itemWidth;

        let scrollSpeed = 0;
        let oldScrollY = 0;
        let scrollY = 0;
        let y = 0;

        /*--------------------
        Lerp
        --------------------*/
        const lerp = (v0, v1, t) => {
            return v0 * (1 - t) + v1 * t;
        };

        /*--------------------
        Dispose
        --------------------*/
        const dispose = scroll => {
            gsap.set($items, {
                x: i => {
                    return i * itemWidth + scroll;
                },
                modifiers: {
                    x: (x, target) => {
                        const s = gsap.utils.wrap(-itemWidth, wrapWidth - itemWidth, parseInt(x));
                        return `${s}px`;
                    }
                }
            });
        };
        dispose(0);

        /*--------------------
        Wheel
        --------------------*/
        const handleMouseWheel = e => {
            scrollY -= e.deltaY * 0;
        };

        /*--------------------
        Touch
        --------------------*/
        let touchStart = 0;
        let touchX = 0;
        let isDragging = false;
        const handleTouchStart = e => {
            touchStart = e.clientX || e.touches[0].clientX;
            isDragging = true;
            $service.classList.add('is-dragging');
        };
        const handleTouchMove = e => {
            if (!isDragging) return;
            touchX = e.clientX || e.touches[0].clientX;
            scrollY += (touchX - touchStart) * 2.5;
            touchStart = touchX;
        };
        const handleTouchEnd = () => {
            isDragging = false;
            $service.classList.remove('is-dragging');
        };

        /*--------------------
        Listeners
        --------------------*/
        $service.addEventListener('mousewheel', handleMouseWheel);

        $service.addEventListener('touchstart', handleTouchStart);
        $service.addEventListener('touchmove', handleTouchMove);
        $service.addEventListener('touchend', handleTouchEnd);

        $service.addEventListener('mousedown', handleTouchStart);
        $service.addEventListener('mousemove', handleTouchMove);
        $service.addEventListener('mouseleave', handleTouchEnd);
        $service.addEventListener('mouseup', handleTouchEnd);

        $service.addEventListener('selectstart', () => {
            return false;
        });

        /*--------------------
        Resize
        --------------------*/
        window.addEventListener('resize', () => {
            serviceWidth = $service.clientWidth;
            itemWidth = $items[0].clientWidth;
            wrapWidth = $items.length * itemWidth;
        });

        /*--------------------
        Render
        --------------------*/
        const render = () => {
            requestAnimationFrame(render);
            y = lerp(y, scrollY, .1);
            dispose(y);

            scrollSpeed = y - oldScrollY;
            oldScrollY = y;

            gsap.to($items, {
                skewX: -scrollSpeed * .2,
                rotate: scrollSpeed * .01,
                scale: 1 - Math.min(100, Math.abs(scrollSpeed)) * 0.003
            });
        };
        render();

        const scrollAmount = itemWidth; // Amount to scroll with each button click

        const scrollTo = (delta) => {
            scrollY += delta;
        };

        document.querySelector('.next').addEventListener('click', () => {
            scrollTo(-scrollAmount);
        });

        document.querySelector('.prev').addEventListener('click', () => {
            scrollTo(scrollAmount);
        });

        // Add this variable to control automatic scrolling
        let autoScrollInterval;

        // Function for automatic scrolling
        const autoScroll = () => {
            console.log('Auto scrolling by:', -scrollAmount);
            scrollTo(-scrollAmount); // Change direction based on your preference
        };

        // Start automatic scrolling every 3 seconds (3000 ms)
        const startAutoScroll = () => {
            console.log('Starting auto scroll');
            autoScrollInterval = setInterval(autoScroll, 3000);
        };

        // Stop automatic scrolling
        const stopAutoScroll = () => {
            console.log('Stopping auto scroll');
            clearInterval(autoScrollInterval);
        };

        // Start automatic scrolling on page load
        startAutoScroll();

        // Stop automatic scrolling on user interaction
        $service.addEventListener('mouseenter', stopAutoScroll);
        $service.addEventListener('mouseleave', startAutoScroll);
    </script>


    <script src="js/jquery.min.js"></script>
    <script src="js/tether.min.js"></script>
    <script src="js/bootstrap.min.js"></script>
    <script src="js/jquery.easing.js"></script>
    <script src="js/jquery-waypoints.js"></script>
    <script src="js/jquery-validate.js"></script>
    <script src="js/owl.carousel.js"></script>
    <script src="js/jquery.prettyPhoto.js"></script>
    <script src="js/numinate.min6959.js?ver=4.9.3"></script>
    <script src="js/lazysizes.min.js"></script>
    <script src="js/main.js"></script>


    <!-- Javascript end-->

    <!-- add active colorto nav li tag -->
    <script>
        document.querySelectorAll('.dropdown a').forEach(link => {
            link.addEventListener('click', function() {
                // Remove 'active' class from all links
                document.querySelectorAll('.dropdown a').forEach(l => l.classList.remove('active'));

                // Add 'active' class to the clicked link
                this.classList.add('active');

                // Store the active link in local storage
                localStorage.setItem('activeLink', this.href);
            });
        });

        // Check local storage on page load
        window.addEventListener('DOMContentLoaded', () => {
            const activeLink = localStorage.getItem('activeLink');
            if (activeLink) {
                const links = document.querySelectorAll('.dropdown a');
                links.forEach(link => {
                    if (link.href === activeLink) {
                        link.classList.add('active');
                    }
                });
            }
        });
    </script>


    <!-- gallery modal -->
    <script>
        function openModal(element) {
            const modal = document.getElementById("modal");
            const modalImg = document.getElementById("modalImage");
            modal.style.display = "block";
            modalImg.src = element.querySelector("img").src;
        }

        function closeModal() {
            const modal = document.getElementById("modal");
            modal.style.display = "none";
        }

        // Close modal when clicking outside of the image
        window.onclick = function(event) {
            const modal = document.getElementById("modal");
            if (event.target === modal) {
                modal.style.display = "none";
            }
        };
    </script>

</body>


</html>